local t = Def.ActorFrame{
	InitCommand=cmd(fov,90);
	
	LoadActor( THEME:GetPathB("","_frame 3x3"), "_rounded blackinset transparent normal", 256, 24)..{
		Name="SongItemBG";
		SetMessageCommand=function(self,params)
			local song = params.Song;
			if not song then return end;
			
			-- players best
			-- [TODO: implement long/marathon?]
			if GAMESTATE:GetSortOrder() == 'SortOrder_Popularity' then
				-- gold, silver, bronze
				if params.Index == 0 then
					self:diffuse(color("1,0.95,0,1"));
				elseif params.Index == 1 then
					self:diffuse(color("0.95,0.9,0.9,1"));
				elseif params.Index == 2 then
					self:diffuse(color("0.95,0.5,0,1"));
				else
					self:diffuse(color("#FFFFFF"));
				end;
			-- any other sort
			else
				if song:IsLong() then
					self:diffuse( color("#FFDDDD") )
				elseif song:IsMarathon() then
					self:diffuse( color("#DDDDFF") )
				else self:diffuse( color("#FFFFFF") )
				end;
			end;
		end;
	};
};

-- yes I could probably just add this to t but I like being neat and tidy.
-- my room would like to disagree.
local u = Def.ActorFrame{};

-- look at me I'm a sattelite
local positions = {
	-14, -- beginner
	-7,  -- easy
	0,   -- medium
	7,   -- hard
	15,  -- expert
	31,  -- edit, which shouldn't be shown
};

for idx, diff in pairs(Difficulty) do -- 0, Difficulty_Beginner
	-- hack to hide edit
	if idx < 6 and not GAMESTATE:IsCourseMode() then
		u[#u+1] = LoadActor( "_DifficultyDisplay" ) .. {
			InitCommand=cmd(x,128;diffuse,DifficultyColor(diff);playcommand,"SetMessage");
			ShowCommand=cmd(visible,true);
			HideCommand=cmd(visible,false);
			BeginCommand=function(self)
				self:y(positions[idx]);
			end;

			SetMessageCommand=function(self,params)
				local song = params.Song;
				-- if there isn't a song or course, don't bother.
				if not song then return end;
				
				local st = GAMESTATE:GetCurrentStyle():GetStepsType();
				local bHasStepsTypeAndDifficulty =
					song and song:HasStepsTypeAndDifficulty( st, diff );
				
				self:playcommand( bHasStepsTypeAndDifficulty and "Show" or "Hide" );
			end;
		};
	end;
end;

t[#t+1] = u;

return t;